#!/bin/sh

end_epoch=$(date -d "$(echo | openssl s_client -connect $ROOT_DOMAIN:443 -servername $ROOT_DOMAIN 2>/dev/null | openssl x509 -enddate -noout | cut -d'=' -f2)" "+%s")
current_epoch=$(date "+%s")
days_left=$((($end_epoch - $current_epoch) / 60 / 60 / 24))

echo "=============================="
echo "Renewal threshold: $RENEWAL_THRESHOLD_IN_DAYS_LEFT days"
echo "Root domain: $ROOT_DOMAIN"
echo "=============================="

if [ $days_left -le $RENEWAL_THRESHOLD_IN_DAYS_LEFT ]; then
    echo "=============================="
    echo "Certificate is $days_left days old, renewing now."
    echo "=============================="
    certbot certonly \
    --agree-tos \
    --debug \
    --manual \
    --manual-auth-hook letsencrypt_authenticator.sh \
    --manual-cleanup-hook letsencrypt_cleanup.sh \
    --manual-public-ip-logging-ok \
    --preferred-challenges http \
    -d $ROOT_DOMAIN \
    -d www.$ROOT_DOMAIN \
    -m $GITLAB_USER_EMAIL
    echo "=============================="
    echo "Certbot finished. Updating GitLab Pages domains."
    echo "=============================="
    curl --request PUT --header "PRIVATE-TOKEN: $CERTBOT_RENEWAL_PIPELINE_GIT_TOKEN" --form "certificate=@/etc/letsencrypt/live/$ROOT_DOMAIN/fullchain.pem" --form "key=@/etc/letsencrypt/live/$ROOT_DOMAIN/privkey.pem" https://gitlab.com/api/v4/projects/$CI_PROJECT_ID/pages/domains/$ROOT_DOMAIN
    curl --request PUT --header "PRIVATE-TOKEN: $CERTBOT_RENEWAL_PIPELINE_GIT_TOKEN" --form "certificate=@/etc/letsencrypt/live/$ROOT_DOMAIN/fullchain.pem" --form "key=@/etc/letsencrypt/live/$ROOT_DOMAIN/privkey.pem" https://gitlab.com/api/v4/projects/$CI_PROJECT_ID/pages/domains/www.$ROOT_DOMAIN
else
    echo "=============================="
    echo "Certificate still valid for $days_left days, no renewal required."
    echo "=============================="
fi
